/****************************************************************************\
**  fsFileUtil.hpp
**
**      fsFileUtil.hpp supplies functions that operate on files.
**
**	Gigawatt Studios
**	Copyright(C) 2000 - All Rights Reserved
\****************************************************************************/

#ifdef FS_FILEUTIL_HPP
#error fsFileUtil.hpp multiply included
#endif
#define FS_FILEUTIL_HPP

#include <string>


namespace fsFileUtil
{
	//============================================================================
	//	FileCreate creates a file with the given name.  This must be done before
	//	reading or writing with a fsFileStream.
	//============================================================================
	void FileCreate(const std::string& i_Filename);

	//============================================================================
	//	FileDelete deletes a file.  The file must exist, or an exception will be
	//	thrown.
	//============================================================================
	void FileDelete(const std::string& i_Filename);

	//============================================================================
	//	FileExists tests if a file exists.
	//============================================================================
	bool FileExists(const std::string& i_Filename);

	//============================================================================
	// ANSIFilenameToLocator returns a locator from an ANSI pathname
	//============================================================================
	void ANSIFilenameToLocator(const std::string& i_String, std::string& o_Locator);

}
